'___
' |he Code Post
' `-' Original Submission
' Visit THE CODE POST at http://home.carolina.rr.com/davs/codepost

'NOTICE: BY USING THIS PROGRAM AND FLI.LIB YOU AGREE TO ASSUME
'        ALL RISKS.  I WILL NOT BE HELD RESPONSIBLE FOR ANY AND
'        ALL DAMAGES THAT MAY COME FROM YOUR USE OF THEM.  IF
'        YOU CANNOT AGREE TO THIS YOU ARE NOT ALLOWED TO USE IT.
'        THERE ARE NO WARRANTEES OR GUARANTEES OF ANY KIND GIVEN
'        NOR IMPLIED.  USE AT YOUR OWN RISK ONLY.

'=============
'FLI.BAS  v1.0
'=============
'A fast and smoooth FLI viewer - ASM Boosted!!

'=====================================================================
'NOTE:   THIS PROGRAM REQUIRES THE FLI.QLB TO BE LOADED FIRST!
'====    START QuickBASIC 4.5 LIKE THIS--->>   QB /L FLI /AH
'
'        * IF YOU DO NOT HAVE THE FLI.QLB, MAKE ONE LIKE THIS *
'
'        In your QB directory, where all your QB files are, type:
'
'             LINK /Q FLI.LIB, FLI.QLB, NUL, BQLB45;
'     
'        That will create FLI.QLB from the FLI.LIB file.
'=====================================================================

'So....what are FLI files? The're animations made popular by autodesk.
'They can be found all over the world.  Find one and feed this player.

'====================================================================

DEFINT A-Z
DECLARE SUB FLILINE (BYVAL INN, BYVAL OUTT)   'LINE COMPRESSED
DECLARE SUB FLICOPY (BYVAL INN, BYVAL OUTT)   'RAW Uncompressed frames
DECLARE SUB FLIPALL (BYVAL INN, BYVAL OUTT)   'COLOR64 (Set FLI palette)
DECLARE SUB FLITICK (BYVAL SPEED%)            'SPEED control (ticks)
DECLARE SUB FLIBLAK ()                        'BLACK screen (CLS)
DECLARE SUB FLIPLAY (file$)                   'The FLI Player
DECLARE SUB MOVMEM (BYVAL FromHere, BYVAL FromHereAddrs, BYVAL ToHere, BYVAL ToHereAddrs, BYVAL BytesToMove)

'$DYNAMIC

'==== Make a double buffer to hold the frame data.

  TYPE DoubleBuffer
     Buffer1 AS STRING * 32000
     Buffer2 AS STRING * 32000
  END TYPE

  DIM SHARED BigBuffer(0) AS DoubleBuffer

'==== Get FLI file to play from user

  IF COMMAND$ = "" THEN
     PRINT
     INPUT "FLI to view> ", FLI$
     IF FLI$ = "" THEN END
  ELSE
     FLI$ = COMMAND$
  END IF

'===== Add the FLI extension if not given

  FOR C% = 1 TO LEN(FLI$)
     IF MID$(FLI$, C%, 1) = "." THEN EXIT FOR
  NEXT
  FLI$ = LEFT$(FLI$, C% - 1) + "." + "FLI"

'===== Play the FLI

  FLIPLAY FLI$

  END

REM $STATIC
SUB FLIPLAY (file$)

'===== Open the FLI file to play

  OPEN file$ FOR BINARY AS #1    'Open the file to use.
  IF LOF(1) = 0 THEN             'Does the file exist?
     CLOSE 1: KILL file$         'No?  Close and kill it.
     EXIT SUB                    'Get out of here.
  END IF

'===== Get FLI information from file

  GET #1, 5, FLI.ID%             'The FLI ID marker
  GET #1, , FLI.FRAMES%          'Number of frames in FLI
  GET #1, , FLI.WIDTH%           'Width of FLI
  GET #1, , FLI.HEIGHT%          'Height of FLI
  GET #1, 17, FLI.SPEED%         'Speed of FLI

'===== Check ID to see if it's a FLI file

  IF FLI.ID% <> &HAF11 THEN      'Check ID marker.  &HAF11 = FLI
     CLOSE 1: EXIT SUB           'If it's not a FLI then exit
  END IF

'===== Check width and height of the FLI.
'===== Only 320x200 is supported here.

  IF FLI.WIDTH% <> 320 OR FLI.HEIGHT% <> 200 THEN    'Is it the right size?
     CLOSE 1: EXIT SUB                               'No? Close and Exit.
  END IF

'===== Set screen mode.

SCREEN 13

'===== The main Playing loop starts here.

DO    'Loop the FLI over and over and over and over...
  
   SEEK 1, 129         'Skip FLI header, goto start of first frame
  
   FOR f% = 1 TO FLI.FRAMES%       'Do all frames
     
      Flikey$ = INKEY$                    'Check for Keypress
     
      IF Flikey$ <> "" THEN               'If so...
      SELECT CASE Flikey$                 '
        CASE CHR$(32): A$ = INPUT$(1)     'SPACE pauses/resumes
        CASE ELSE: EXIT DO                'Any Other key exits
      END SELECT
      END IF
  
      Fpos& = SEEK(1)           'Save file pointer (frame)
      FRM$ = INPUT$(16, 1)      'Now we grab the frame header
      FrameSize& = CVL(MID$(FRM$, 1, 4))    'The size of the frame
      Chunks% = CVI(MID$(FRM$, 7, 2))

      FOR C% = 1 TO Chunks%
         Cpos& = SEEK(1)
         GET #1, , ChunkSize&
         GET #1, , ChunkType%
         Cpos& = Cpos& + ChunkSize&
     
         SELECT CASE ChunkType%
            CASE 11
               GET #1, , BigBuffer(0)
               CALL FLIPALL(VARSEG(BigBuffer(0)), VARPTR(BigBuffer(0)))
            CASE 12
               GET #1, , BigBuffer(0)
               CALL FLILINE(VARSEG(BigBuffer(0)), VARPTR(BigBuffer(0)))
            CASE 13: CALL FLIBLAK
            CASE 15
               '=================================================
               'Sorry...the ASM routine to decode the BRUN chunks
               'isn't working well yet.  So, Were going to decode
               'those the old slow way.  It's not so bad.  Usually
               'only the first FLI is BRUN encoded.  The rest are
               'usually Line compressed.  I've used some tricks to
               'speed it up some.  First, I load the data in packs
               'instead of byte-by-byte to speed up loading.  And,
               'I use a MemCopy routine to "out" it to the screen.
               '=================================================
               x% = 0
               FOR y% = 0 TO 199
                  ppos& = SEEK(1)
                  C$ = INPUT$(9500, 1): m% = 1
                  paks% = ASC(MID$(C$, m%, 1))
                  m% = m% + 1
                  FOR D% = 1 TO paks%
                     p% = ASC(MID$(C$, m%, 1)): m% = m% + 1
                     IF p% < 128 THEN
                        LINE (x%, y%)-STEP(p% - 1, 0), ASC(MID$(C$, m%, 1))
                        m% = m% + 1
                     ELSE
                        p% = (256 - p%)
                        Row$ = MID$(C$, m%, p%)
                        m% = m% + p%
                        SP = CVI(MID$(MKL$(x% + y% * 320&), 1, 2))
                        CALL MOVMEM(VARSEG(Row$), SADD(Row$), &HA000, SP, p%)
                        Row$ = ""
                     END IF
                     x% = x% + p%
                  NEXT
                  x% = 0: SEEK #1, ppos& + m% - 1: C$ = ""
               NEXT
            CASE 16       '16 = COPY Uncompressed 64,000 bytes
               GET #1, , BigBuffer(0)
               CALL FLICOPY(VARSEG(BigBuffer(0)), VARPTR(BigBuffer(0)))
            CASE ELSE: EXIT DO:
         END SELECT
         SEEK #1, Cpos&
      NEXT
      SEEK 1, Fpos& + FrameSize&
  
      FLITICK FLI.SPEED%
  
   NEXT
LOOP

CLOSE 1

END SUB

